#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_SupplyInventoryReport : BaseTest 
	{
		
		private BOL.SupplyInventoryReport _tstSIR;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			this._tstSIR = new BOL.SupplyInventoryReport();	
		}

		[Test]
		public void Ctor_Pass()
		{
			BOL.SupplyInventoryReport tmpSIR = new BOL.SupplyInventoryReport();

			Assert.IsNotNull(tmpSIR);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Fail()
		{
		}

		[Test]
		public void SupplyTypeIds_Pass()
		{
			System.Collections.ArrayList alTest = this._tstSIR.SupplyTypeIds;

			Assert.AreEqual(this._tstSIR.SupplyTypeIds, alTest);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void SupplyTypeIds_Fail()
		{
		}

		[Test]
		public void InventoryFilter_Pass()
		{
			Common.SupplyInventoryReportFilter tstValue = Common.SupplyInventoryReportFilter.Unsatisfactory;

			this._tstSIR.InventoryFilter = tstValue;

			Assert.AreEqual(this._tstSIR.InventoryFilter, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void InventoryFilter_Fail()
		{
		}

		[Test]
		public void ReceiptStartDate_Pass()
		{
			System.DateTime tstValue = System.DateTime.Now;

			this._tstSIR.ReceiptStartDate = tstValue;

			Assert.AreEqual(this._tstSIR.ReceiptStartDate, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ReceiptStartDate_Fail()
		{
		}

		[Test]
		public void ReceiptEndDate_Pass()
		{
			System.DateTime tstValue = System.DateTime.Now;

			this._tstSIR.ReceiptEndDate = tstValue;

			Assert.AreEqual(this._tstSIR.ReceiptEndDate, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ReceiptEndDate_Fail()
		{
		}

		[Test]
		public void ExpirationStartDate_Pass()
		{
			System.DateTime tstValue = System.DateTime.Now;

			this._tstSIR.ExpirationStartDate = tstValue;

			Assert.AreEqual(this._tstSIR.ExpirationStartDate, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ExpirationStartDate_Fail()
		{
		}

		[Test]
		public void ExpirationEndDate_Pass()
		{
			System.DateTime tstValue = System.DateTime.Now;

			this._tstSIR.ExpirationEndDate = tstValue;

			Assert.AreEqual(this._tstSIR.ExpirationEndDate, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ExpirationEndDate_Fail()
		{
		}

		[Test]
		public void GetSupplyInventoryReport_Pass()
		{
			for (int ndx=1; ndx < 20; ndx++)
			{
				this._tstSIR.SupplyTypeIds.Add(ndx);
			}

			this._tstSIR.InventoryFilter = Common.SupplyInventoryReportFilter.Expired;

			DataTable dtTest = this._tstSIR.GetSupplyInventoryReport();

			Assert.IsTrue(dtTest.Rows.Count >= 0);
		}

		[Test]
		public void GetSupplyInventoryReport_Fail()
		{
			this._tstSIR.InventoryFilter = Common.SupplyInventoryReportFilter.Expired;
			this._tstSIR.SupplyTypeIds.Add(1);
			this._tstSIR.ExpirationEndDate = System.DateTime.Now.AddYears(-5);
			this._tstSIR.ExpirationStartDate = System.DateTime.Now.AddYears(-4);

			DataTable dtTest = this._tstSIR.GetSupplyInventoryReport();

			Assert.IsTrue(dtTest.Rows.Count == 0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void GenerateAndPrintReport_Pass()
		{
			// There are no pass conditions either; this method is not implemented
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void GenerateAndPrintReport_Fail()
		{
			// There are no pass conditions either; this method is not implemented
		}
	}
}
#endif
